import numpy as np
import argparse
import cv2

ap = argparse.ArgumentParser()
ap.add_argument("-i" ,"--image", required=True, help="Chemin vers l'image à analyser")
ap.add_argument("-p", "--prototxt", required=True,help="path to Caffe 'deploy' prototxt file")
ap.add_argument("-m", "--modele", required=True,help="path to Caffe pre-trained model")
ap.add_argument("-c", "--confiance", type=float, default=0.2,help="probabilité minimale pour filtrer les détections faibles")
args = vars(ap.parse_args())

CLASSES = ["arriere-plan", "avion", "velo", "oiseau", "bateau", "bouteille", "autobus", "voiture", "chat", "chaise", "vache", "table","chien", "cheval", "moto", "personne", "plante en pot", "mouton", "sofa", "train", "moniteur"]
COULEURS = np.random.uniform(0, 255, size=(len(CLASSES), 3))

net = cv2.dnn.readNet(args["prototxt"], args["modele"])
image=cv2.imread(args["image"])

(h, w) = image.shape[:2]
blob = cv2.dnn.blobFromImage(cv2.resize(image, (300, 300)), 0.007843, (300, 300),127.5)

net.setInput(blob)
detections = net.forward()

for i in np.arange(0, detections.shape[2]):
	confiance = detections[0, 0, i, 2]
	if confiance > args["confiance"]:
		index = int(detections[0, 0, i, 1])
		box = detections[0, 0, i, 3:7] * np.array([w, h, w, h])
		(startX, startY, endX, endY) = box.astype("int")
		label = str(CLASSES[index]) +" : " + str(round((confiance * 100),2))
		y = startY - 20 if startY - 20 > 20 else startY + 20
		cv2.rectangle(image, (startX, startY), (endX, endY),COULEURS[index], 10)
		cv2.putText(image, label, (startX, y),cv2.FONT_HERSHEY_SIMPLEX, 5, COULEURS[index], 5)

cv2.imshow("Frame", image)
cv2.waitKey(0)